#!/bin/bash

. global.sh

mkdir -p $INDEXER_DIR/sge

if [ -e $INDEXER_DIR/sge/lattice_indexing_lvcsr ]; then
	rm $INDEXER_DIR/sge/lattice_indexing_lvcsr
fi
mkdir $INDEXER_DIR/sge/lattice_indexing_lvcsr
echo -n > $INDEXER_DIR/sge/lattice_indexing_lvcsr.scriptlist

for i in `cat $INDEXER_DIR/lists/lattices.htk.lvcsr.latlist`; do
	script_name=`basename "$i" | sed 's/\.latt*\.gz//'`.sh
#		echo "$script_name";
	script=$INDEXER_DIR/sge/lattice_indexing_lvcsr/$script_name
	cat << EOF > $script
#!/bin/bash
cd $INDEXER_DIR/scripts
./5_lattice_index_lvcsr.sh $i
EOF
	chmod a+x $script

	echo $script >> $INDEXER_DIR/sge/lattice_indexing_lvcsr.scriptlist
done

