#!/usr/bin/python

from __base import *

silence_file = "silence_8000.wav"

# ------------------------------------------------------------------------------
def f_analyze_wav(a_wav_file):
   """ - analyze source wav - """
   src_info_f = os.popen("wavinfo %s" % a_wav_file)

   for line in src_info_f:
      if "Channels" in line:
         channel_cnt = int(line.split('\t')[1])
      elif "Sample Rate" in line:
         sample_rate = int(line.split('\t')[1])

   src_info_f.close()

   return (channel_cnt,sample_rate)

# ------------------------------------------------------------------------------
def f_convert_records(a_src,a_trg_wav):
   """ convert given record to signed-integer 16b 8000Hz wav """
   rm_conv_wav = False
   convert_wav_name = ""

   # - test if target is wav -
   if os.path.splitext(a_trg_wav)[-1] != ".wav":
      err_msg("Target record \"%s\" is not a wav" % a_trg_wav)
      return 1

   # - test if source record exists -
   if not os.path.isfile(a_src):
      err_msg("Record \"%s\" is not regular file" % a_src)
      return 1

   # - test if source is already wav, if not convert it -
   if os.path.splitext(a_src)[-1] != ".wav":
      rm_conv_wav = True
      convert_wav_name = "/tmp/speech-tagging-%d.wav" % os.getpid()
      if f_execute("sox %s %s" % (a_src,convert_wav_name)) != 0:
         err_msg("Cannot convert record \"%s\" to wav" % a_src)
         return 1
   else:
      convert_wav_name = a_src

   tmp_wav_name = "/tmp/speech-tagging-tmp-%d.wav" % os.getpid()
   (channel_cnt,sample_rate) = f_analyze_wav(convert_wav_name)

   # - convert wav to required format (speed = (orig_sample_rate/sample_rate)*channel_cnt ??) -
   if f_execute("sox -r %d -c %d %s -e signed-integer -b 16 -r 8000 -c 1 %s" % (sample_rate,channel_cnt,convert_wav_name,tmp_wav_name)) != 0:
      err_msg("Cannot convert %s to %s" % (convert_wav_name,tmp_wav_name))
      return 1

   # - rm converted wav file -
   if rm_conv_wav:
      assert f_execute("rm -f %s" % convert_wav_name) == 0

   # - concatenate record with silence -
   if f_execute("sox -m %s %s %s" % (tmp_wav_name,silence_file,a_trg_wav)):
      err_msg("Cannot merge records %s %s" % (tmp_wav_name,silence_file))
      return 1

   # - rm tmp wav file -
   assert f_execute("rm -f %s" % tmp_wav_name) == 0

   return 0

# - PROGRAM START - ============================================================
if (len(sys.argv) != 3):
   err_msg("Expected exactly two parameters: <source record> <target wav>")
   sys.exit(2)

if f_convert_records(sys.argv[1],sys.argv[2]) != 0:
   sys.exit(2)


