#!/bin/bash

. global.sh

mkdir -p $INDEXER_DIR/sge

if [ -e $INDEXER_DIR/sge/lattice_indexing_lvcsr ]; then
	rm -r $INDEXER_DIR/sge/lattice_indexing_lvcsr
fi
mkdir $INDEXER_DIR/sge/lattice_indexing_lvcsr
echo -n > $INDEXER_DIR/sge/lattice_indexing_lvcsr.scriptlist

for i in $INDEXER_DIR/lists/*.latlist; do
	doc_name=`basename "$i" .latlist`
#		echo "$script_name";
	script=$INDEXER_DIR/sge/lattice_indexing_lvcsr/$doc_name.sh
	cat << EOF > $script
#!/bin/bash
cd $INDEXER_DIR/scripts
./5_lattice_index_lvcsr_concat.sh $doc_name $i
EOF
	chmod a+x $script

	echo $script >> $INDEXER_DIR/sge/lattice_indexing_lvcsr.scriptlist
done

