#!/usr/bin/python

from __mysql import * 
from string import maketrans

# - record names, that are not in DB -
nidb_record_names = []

def f_get_rec_length(rt_wav_name):
   wav_info_f = os.popen("wavinfo '%s'" % rt_wav_name)
   for line in wav_info_f:
      if "wavDataSize" in line:
         data_size = int(line.split(" ")[1])
      elif "Bytes / Sec" in line:
         bytes_p_sec = int(line.split("\t")[1])

   wav_info_f.close()
   return data_size/float(bytes_p_sec)

# ------------------------------------------------------------------------------
def f_remove_original_record(a_file):
   #f_execute("rm -rf '%s'" % a_file)
   return True

# ------------------------------------------------------------------------------
def f_create_record_list(a_rec_list):
   """ - create record list file - """
   record_list_f = open("recognizer/wavs.list","w")

   in_tab = "_ \"'`"
   out_tab = "-----"
   tran_tab = maketrans(in_tab,out_tab)

   for arg in a_rec_list:

      # - test if file is record -
      is_record_file = True
      sox_out_f = os.popen("sox --i '%s' 2>&1" % arg)
      for line in sox_out_f:
            if "FAIL" in line:
               is_record_file = False
               break
      sox_out_f.close()

      # - skip if file is not record -
      if not is_record_file:
         wrn_msg("File \"%s\" is not record, skipping" % arg)
         f_remove_original_record(arg)

      else:
         # - generate target wav name, replace underscores by dashes -
         tmp_rec_name = os.path.splitext(os.path.basename(arg))[-2]
         rec_name = tmp_rec_name.translate(tran_tab,'xm')
         rt_wav_name = "record-trunk/%s.wav" % rec_name

         # - test if record <rec_name> is in database -
         f_mysql_execute("SELECT * FROM records WHERE name=\"%s\"" % rec_name)
         exist_in_database = db_cursor.rowcount != 0

         # - skip already indexed record -
         if exist_in_database:
            log_msg("Record \"%s\" is already indexed, skipping" % rec_name)
            f_remove_original_record(arg)

            # - assertion -
            assert db_cursor.rowcount == 1

            # - test if record exist - NO = database record-trunk inconsistence -
            if not os.path.isfile(rt_wav_name):
               err_msg("Database and record-trunk inconsistence at record %s" % rt_wav_name)
               return 1

         # - convert record and store it to record-trunk directory -
         else:
            log_msg("Record \"%s\" not exist in database, converting" % rec_name)
            
            if f_execute("./convert_record.py '%s' %s" % (arg,rt_wav_name)) != 0:
               err_msg("Cannot convert record \"%s\" to \"%s\"" % (arg,rt_wav_name));
               return 1
            
            f_remove_original_record(arg)

            # - compute record length -
            nidb_record_names.append((rec_name,f_get_rec_length(rt_wav_name)))

            # - insert record path to record list -
            log_msg("Adding record to list: ../%s" % rt_wav_name)
            record_list_f.write("../%s\n" % rt_wav_name)

   record_list_f.close()
   return 0

# ------------------------------------------------------------------------------
def f_insert_records_to_database():
   if len(nidb_record_names) > 0:
      sql_cmd = "INSERT INTO records VALUES(0,\"%s\",%f);" % (nidb_record_names[0][0],nidb_record_names[0][1])
      for rec_info in nidb_record_names[1:]:
         sql_cmd = sql_cmd + ("\nINSERT INTO records VALUES(0,\"%s\",%f);" % (rec_info[0],rec_info[1]))

      f_mysql_execute(sql_cmd)

   return 0

# ------------------------------------------------------------------------------
def f_tag_records(a_tag_list):
   f_execute("./search_words.py %s" % " ".join(a_tag_list))
   return 0

# ------------------------------------------------------------------------------
def f_backup_speech_index_data():
   backup_list = os.listdir("speech-index-trunk")

   if len(backup_list) != 0:
      backup_list_int = list(int(value) for value in backup_list)
      backup_list_int.sort()
      act_backup = int(backup_list_int[-1]) + 1
   else:
      act_backup = 0

   f_execute("mkdir speech-index-trunk/%d;mv indexer/idx indexer/lists indexer/sge speech-index-trunk/%d/" % (act_backup,act_backup))
   return 0

# ------------------------------------------------------------------------------
def f_index_and_search_tags_in_records(a_rec_list):
   if f_create_record_list(a_rec_list) != 0:
      return 1

   if len(nidb_record_names):
      ret_val = f_execute("rm -rf recognizer/out/*;cd recognizer;./run_list.sh;cd ..")
      if ret_val != 0:
         err_msg("Recognizer error, value: %d" % ret_val)
         return 1

      ret_val = f_execute("cd indexer;./run.sh;cd ..")
      if ret_val != 0:
         err_msg("Indexer error, value: %d" % ret_val)
         return 1

      f_insert_records_to_database()
      f_tag_records(f_get_tags(1))

      f_backup_speech_index_data()

   return 0

# ------------------------------------------------------------------------------
def f_mark_tags_as_processed():
   sql_cmd = "UPDATE tags SET used=1 WHERE used=0"
   f_mysql_execute(sql_cmd)

# ------------------------------------------------------------------------------
def f_search_tags_in_already_indexed_records():
   backup_list = os.listdir("speech-index-trunk")

   # - test if there are any unused tags -
   sql_cmd = "SELECT name FROM tags WHERE used=0"
   f_mysql_execute(sql_cmd)

   if db_cursor.rowcount != 0:
      tag_list = f_get_tags(0)

      f_execute("rm -rf indexer/idx indexer/lists indexer/sge")
      if len(backup_list) != 0:
         for backup in backup_list:
            f_execute("cp -r speech-index-trunk/%s/* indexer/" % backup)
            f_tag_records(tag_list)
      
      f_execute("rm -rf indexer/idx indexer/lists indexer/sge")
      f_mark_tags_as_processed()

   return 0

# ------------------------------------------------------------------------------
def f_exit(a_ret_val):
   """ exit program """
   f_release_database(a_ret_val)
   sys.exit(a_ret_val)

# - PROGRAM START - ============================================================
if (len(sys.argv) >= 2):
   if f_index_and_search_tags_in_records(sys.argv[1:]) != 0:
      f_exit(1)
else:
   if f_search_tags_in_already_indexed_records() != 0:
      f_exit(1)

f_exit(0)

