#!/usr/bin/python

from __mysql import * 

# ------------------------------------------------------------------------------
def f_rec_db_list_to_set(a_rec_db_list):
   rec_list = []
   for rec_db in a_rec_db_list:
      rec_list.append(rec_db[0])

   return set(rec_list)

# ------------------------------------------------------------------------------
def f_and_operator(a_first,a_second):
   result = (a_first[0] & a_second[0],{})
   for elm in result[0]:
      result[1][elm] = min(a_first[1][elm],a_second[1][elm])
   return result

# ------------------------------------------------------------------------------
def f_or_operator(a_first,a_second):
   result = (a_first[0] | a_second[0],{})
   for elm in result[0]:
      if a_first[1].has_key(elm):
         probab = a_first[1][elm]
      else:
         probab = 0.0

      if a_second[1].has_key(elm):
         probab = max(probab,a_second[1][elm])

      result[1][elm] = probab
   return result

# ------------------------------------------------------------------------------
def f_not_operator(a_src):
   f_mysql_execute("SELECT id FROM records")
   result = [f_rec_db_list_to_set(db_cursor.fetchall()),{}]

   rm_set = set()
   for elm in result[0]:

      # - invert probabilities -
      if a_src[1].has_key(elm):
         probab = 1.0 - a_src[1][elm]
      else:
         probab = 1.0

      if probab <= 0.0:
         rm_set.add(elm)
      else:
         result[1][elm] = probab

   result[0] = result[0] - rm_set

   return tuple(result)

# ------------------------------------------------------------------------------
def f_process_query(a_expression):
   rec_set_stack = []
   tag_set = set()

   # - rewrite expression to postfix notation -
   exp_stack_f = os.popen("cd exp_parser;./exp_parser '%s' 2>&1" % a_expression)
   for line in exp_stack_f:

      if "ERROR" in line:
         print -1
         return 1

      # - process expression operands -
      if line == "and\n":
         rec_set_stack.append(f_and_operator(rec_set_stack.pop(),rec_set_stack.pop()))
      elif line == "or\n":
         rec_set_stack.append(f_or_operator(rec_set_stack.pop(),rec_set_stack.pop()))
      elif line == "not\n":
         rec_set_stack.append(f_not_operator(rec_set_stack.pop()))

      # - process tag -
      else:
         upp_tag_name = line[:-1].upper()

         # - select records tha contain tag -
         f_mysql_execute("SELECT DISTINCT o.id_rec,o.id_tag FROM occurrences AS o JOIN tags AS t ON o.id_tag = t.id WHERE t.name = %s" % upp_tag_name)
         db_result = db_cursor.fetchall()
         rec_set = f_rec_db_list_to_set(db_result)

         # - find max tag probability for each record -
         rec_prob = {}

         if len(db_result) > 0:
            tag_id = db_result[0][1]
            tag_set.add(tag_id)
            for rec in rec_set:
               f_mysql_execute("SELECT probab FROM occurrences WHERE id_rec = %s AND id_tag = %s ORDER BY probab DESC LIMIT 1" % (rec,tag_id))  
               row = db_cursor.fetchone()
               rec_prob[rec] = float(row[0]) + 0.01;

         rec_set_stack.append((rec_set,rec_prob))

   exp_stack_f.close()

   # - assertion, stack should contain only one record set with probabilities -
   assert len(rec_set_stack) == 1

   result_set = rec_set_stack[0]

   # - print output -
   print len(result_set[0])
   if len(result_set[0]):

      sorted_result = [(v,k) for k,v in result_set[1].items()]
      sorted_result.sort()
      sorted_result.reverse()

      for sr in sorted_result:
         print str(sr[1]),
      print
      for sr in sorted_result:
         print str(sr[0]),
      print
      for tag in tag_set:
         print tag,

# ------------------------------------------------------------------------------
def f_exit(a_ret_val):
   """ exit program """
   f_release_database(a_ret_val)
   sys.exit(a_ret_val)

# - PROGRAM START - ============================================================
if len(sys.argv) != 2:
   err_msg("Expect exactly one argument")
   f_exit(1)

f_process_query(sys.argv[1])

