-- ----------------------------------------------------------------------------
-- Author: ipribyl
-- Date: 2010-10-04 12:04:33 
-- ----------------------------------------------------------------------------
-- database 'weknowit' must exist
USE weknowit;
-- ----------------------------------------------------------------------------

DROP TABLE IF EXISTS tags;
DROP TABLE IF EXISTS records;
DROP TABLE IF EXISTS occurrences;
DROP TABLE IF EXISTS requests;

-- ----------------------------------------------------------------------------

CREATE TABLE tags (
	id   INT PRIMARY KEY AUTO_INCREMENT,
	name VARCHAR(128) UNIQUE NOT NULL,
	used TINYINT NOT NULL DEFAULT 0
);

CREATE TABLE records (
	id   INT PRIMARY KEY AUTO_INCREMENT,
	name VARCHAR(1000) UNIQUE NOT NULL,
	length FLOAT(10,2) NOT NULL
);

CREATE TABLE occurrences (
	id_tag INT NOT NULL,
	id_rec INT NOT NULL,
	probab FLOAT(3,2) NOT NULL,
	begin  FLOAT(10,2) NOT NULL,
	end    FLOAT(10,2) NOT NULL,
--	PRIMARY KEY (id_tag, id_rec),
	FOREIGN KEY (id_tag) REFERENCES tags,
	FOREIGN KEY (id_rec) REFERENCES records
);

CREATE TABLE requests (
   id BIGINT PRIMARY KEY AUTO_INCREMENT,
   uri VARCHAR(1024) NULL DEFAULT NULL,
   type INT NOT NULL COMMENT '0 = index record, 1 = process unused tags, 2 = add new tags separated by space (phrases are in ")'
);

-- -----------------------------------------------------------------------------
