﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;
using ObjectModel.InformationElements;
using ObjectModel.InformationElements.Renderers;

namespace Renderers.TextFileRenderer
{
    public class TextFileRenderer : IInformationElementRenderer
    {
        string fileName = null;
        TextWriter writer = null;

        public bool SetUp()
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();

            saveFileDialog1.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*";
            saveFileDialog1.FilterIndex = 1;
            saveFileDialog1.RestoreDirectory = true;
            saveFileDialog1.AddExtension = true;
            saveFileDialog1.DefaultExt = "txt";

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                this.fileName = saveFileDialog1.FileName;
                this.writer = new StreamWriter(this.fileName);
				return true;
            }
			return false;
        }
        public void Close()
        {
            this.writer.Flush();
            this.writer.Close();
        }

        public void RenderData(InformationElementBase renderedObject, Object args)
        {
            StringBuilder sb = new StringBuilder("------");
			sb.AppendLine();
            int lineCounter = 0, rowCounter = 0;
            foreach (byte item in renderedObject.DataColl.Data)
            {
                //000: 
                if (lineCounter == 0)
                {
                    sb.AppendFormat((rowCounter++).ToString("D3"));
                    sb.Append(": ");
                }
                //01
                sb.AppendFormat(item.ToString("x2"));
                sb.Append(" ");
                lineCounter++;
                if ((lineCounter) % 8 == 0)
                {
                    if (lineCounter % 16 == 0)
                    {
                        sb.AppendLine();
                        lineCounter = 0;
                    }
                    else
                        sb.Append("- ");
                }
            }
            sb.AppendLine();
            //konzola je kontext daneho renderera
            this.writer.Write(sb.ToString());
        }
        public void RenderInformationElements(InformationElementBase renderedObject, Object args)
        {
            int level = 0;
            if (args is int)
                level = (int)args;

            foreach (KeyValuePair<string, Object> element in renderedObject.Items)
            {
                //ak je to protokol tak ma v sebe information elementy
                if (element.Value is InformationElementBase)
                {
                    InformationElementBase iElement = element.Value as InformationElementBase;
                    //vyrenderuj element pomocou na to urcenej funkcie
                    iElement.RenderInformationElements(level + 3);
                }
                else
                {
                    StringBuilder sb = new StringBuilder(new string(' ', level));
                    sb.Append(element.Key);
                    sb.Append(": ");
                    sb.AppendLine(element.Value.ToString());

                    //konzola je kontext daneho renderera
                    this.writer.Write(sb.ToString());
                }
            }
        }

    }
}
