﻿using System;
using System.Collections.Generic;
using System.Text;
using ObjectModel.InformationElements;
using ObjectModel.Protocols;
using ObjectModel.InformationElements.Renderers;


namespace ObjectModel.Renderers
{
    public class ConsoleTextRenderer : IInformationElementRenderer
    {
        public bool SetUp()
        {
			return true;
		}
        public void Close()
        { }
        public void RenderData(InformationElementBase renderedObject, Object args)
        {
            StringBuilder sb = new StringBuilder();
            int lineCounter = 0, rowCounter = 0;
            foreach (byte item in renderedObject.DataColl.Data)
            {
                //000: 
                if (lineCounter == 0)
                {
                    sb.AppendFormat((rowCounter++).ToString("D3"));
                    sb.Append(": ");
                }
                //01
                sb.AppendFormat(item.ToString("x2"));
                sb.Append(" ");
                lineCounter++;
                if ((lineCounter) % 8 == 0)
                {
                    if (lineCounter % 16 == 0)
                    {
                        sb.AppendLine();
                        lineCounter = 0;
                    }
                    else
                        sb.Append("- ");
                }
            }
            sb.AppendLine();
            //konzola je kontext daneho renderera
            Console.Write(sb.ToString());
        }
        public void RenderInformationElements(InformationElementBase renderedObject, Object args)
        {
            int level = (int)args;
            foreach (KeyValuePair<string, Object> element in renderedObject.Items)
            {
                //ak je to protokol tak ma v sebe information elementy
                if (element.Value is InformationElementBase)
                {
                    InformationElementBase iElement = element.Value as InformationElementBase;
                    //vyrenderuj element pomocou na to urcenej funkcie
                    iElement.RenderInformationElements(level + 3);
                }
                else
                {
                    StringBuilder sb = new StringBuilder(new string(' ', level));
                    sb.Append(element.Key);
                    sb.Append(": ");
                    sb.AppendLine(element.Value.ToString());

                    //konzola je kontext daneho renderera
                    Console.Write(sb.ToString());
                }
            }
        }
    }
}
