﻿using System;
using System.Collections;

namespace ObjectModel.InformationElements
{
    public class DataCollection : IEnumerable
    {
        byte[] data;

        public DataCollection()
        { }
        public DataCollection(byte[] data)
        {
            this.data = data;
        }

        public byte[] Data
        {
            get { return data; }            
        }

        public byte this[int i]
        {
            get { return this.data[i]; }
            set { this.data[i] = value; }
        }       

        public IEnumerator GetEnumerator()
        {
            return this.data.GetEnumerator();
        }
        public int Length
        {
            get { return this.data.Length; }
        }

        
    }
}
