﻿using System;
using System.Xml;

namespace MetaModel
{
    public abstract class ObjectBase : IObjectBase
    {
        protected XmlNode currentNode;
        protected Guid id;
        protected String name;
       
        public ObjectBase()
        { }
        public ObjectBase(XmlNode node)
        {
            this.currentNode = node;
            this.LoadFromXml(node);
        }

        public Guid Id
        {
            get { return id; }
            set { id = value; }
        }
        public String Name
        {
            get { return name; }
            set { name = value; }
        }

        public abstract void SaveToXml(XmlNode parentNode);
        public abstract void LoadFromXml(XmlNode node);   
        
        protected void SaveId(XmlDocument parentDoc)
        {
            //Id .. povinne
            XmlAttribute idAttr = parentDoc.CreateAttribute("Id");
            idAttr.Value = this.id.ToString("B");            
            this.currentNode.Attributes.Append(idAttr);
        }

        protected void SaveName(XmlDocument parentDoc)
        {
            //Id .. povinne
            XmlAttribute nameAttr = parentDoc.CreateAttribute("Name");
            nameAttr.Value = this.name.ToString();
            this.currentNode.Attributes.Append(nameAttr);
        }

        public static string NodeName;        
    }
}
