﻿using System.Xml;
using System;
using MetaModel.Model.DataSets;

namespace MetaModel.Model
{
    public class ProtocolModel
    {
        Header m_header;
        Data m_data;

        public ProtocolModel()
        { }
        public ProtocolModel(XmlNode node)
        {
            this.LoadFromXml(node);
        }

        #region Public interface
        public Header Header
        {
            get { return m_header; }
            set { m_header = value; }
        }
        public Data Data
        {
            get { return m_data; }
            set { m_data = value; }
        }
        #endregion

        /// <summary>
        /// Funkcia vyvtvory XmlDocument obsahujuci informacie o celom modeli.
        /// </summary>
        /// <returns></returns>
        public XmlDocument SaveToXml()
        {
            XmlDocument parentDoc = new XmlDocument();
            //Create an XML declaration. 
            XmlDeclaration xmldecl;
            xmldecl = parentDoc.CreateXmlDeclaration("1.0", System.Text.Encoding.UTF8.BodyName, null);
            parentDoc.AppendChild(xmldecl);

            XmlNode node = parentDoc.CreateElement("ProtocolModel");
            parentDoc.AppendChild(node);

            if (this.m_header != null)
                this.m_header.SaveToXml(node);
            if (this.m_data != null)
                this.m_data.SaveToXml(node);

            return parentDoc;
        }

        public void LoadFromXml(System.Xml.XmlNode node)
        {
            //data
            XmlNode dataNode = node[Data.NodeName];
            if (dataNode != null)
                this.m_data = new Data(dataNode);
            //header
            XmlNode headerNode = node[Header.NodeName];
            if (headerNode != null)
                this.m_header = new Header(headerNode);
        }
		public static ProtocolModel LoadFromXml(String fileName)
		{
			if (System.IO.File.Exists(fileName))
			{
				XmlDocument document = new XmlDocument();
				document.Load(fileName);
				//nacitaj model
				XmlNode protocolNode = document["ProtocolModel"];
				if (protocolNode != null)
				{
					ProtocolModel model = new ProtocolModel(protocolNode);
					return model;
				}
			}
			return null;
		}
    }
}
