﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using MetaModel.Model.DataSets;
using System.CodeDom;

namespace MetaModel.Model.InformationSubElementNs
{
    public enum Type
    {
        Text, //subElement obsahujuci tabulku vyznamov
        Value        
    }

    public class InformationSubElement : ObjectBase, IDataChild
    {
        List<Meaning> m_meanings = new List<Meaning>();
        CustomToString m_CustomToString;
        CustomParser m_CustomParser;
        Int32 m_length;
        Type m_type = Type.Text;
        Data m_parent = null;

        public InformationSubElement()
        { }
        public InformationSubElement(Data parent_)            
        {
            this.m_parent = parent_;
        }
        public InformationSubElement(XmlNode node)
            : base(node)
        { }
        public InformationSubElement(XmlNode node, Data parent_)
            : base(node)
        {
            this.m_parent = parent_;
        }
        public InformationSubElement(String name_)
        {
            this.id = Guid.NewGuid();
            this.name = name_;
        }

        #region Public Interface
        public Data Parent
        {
            get { return m_parent; }
            set { m_parent = value; }
        }
        public List<Meaning> Meanings
        {
            get { return m_meanings; }
            set { m_meanings = value; }
        }
        public CustomToString CustomToString
        {
            get { return m_CustomToString; }
            set { m_CustomToString = value; }
        }
        public CustomParser CustomParser
        {
            get { return m_CustomParser; }
            set { m_CustomParser = value; }
        }
        public Int32 Length
        {
            get { return m_length; }
            set { m_length = value; }
        }
        public Type Type
        {
            get { return m_type; }
            set { m_type = value; }
        }
        #endregion

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(InformationSubElement.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //Id .. povinne
            this.SaveId(parentDoc);
            //Name .. povinne
            this.SaveName(parentDoc);

            //Length .. povinne
            XmlAttribute lenAttr = parentDoc.CreateAttribute("Length");
            lenAttr.Value = this.m_length.ToString();
            this.currentNode.Attributes.Append(lenAttr);

            //Type
            if (this.m_type != Type.Text)
            {
                XmlAttribute typeAttr = parentDoc.CreateAttribute("Type");
                typeAttr.Value = this.m_type.ToString();
                this.currentNode.Attributes.Append(typeAttr);
            }
            //ulozim meanings
            foreach (var item in this.m_meanings)
                item.SaveToXml(this.currentNode);
            //custom parser
            if (this.m_CustomParser != null)
                this.m_CustomParser.SaveToXml(this.currentNode);
            //custom toString
            if (this.m_CustomToString != null)
                this.m_CustomToString.SaveToXml(this.currentNode);
        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //Length .. povinne
            XmlAttribute lenAttr = node.Attributes["Length"];
            if (lenAttr != null)
                this.m_length = int.Parse(lenAttr.Value);
            //Id .. povinne
            XmlAttribute idAttr = node.Attributes["Id"];
            if (idAttr != null)
            {
                this.Id = new Guid(idAttr.Value);
                ObjectReferenceLoadCache.RegisterReferencedObject += this.registerReferencedObject;
            }
            //Type .. nepovinne
            XmlAttribute typeAttr = node.Attributes["Type"];
            if (typeAttr != null)
                this.m_type = (Type)Enum.Parse(typeof(Type), typeAttr.Value);

            //Name .. povinne
            XmlAttribute nameAttr = node.Attributes["Name"];
            if (nameAttr != null)
                this.name = nameAttr.Value;

            //nacitam premenne          
            //meanings
            XmlNodeList meanings = node.SelectNodes(Meaning.NodeName);
            foreach (XmlNode item in meanings)
                this.m_meanings.Add(new Meaning(item));
            //custom parser
            XmlNode customParser = node[CustomParser.NodeName];
            if (customParser != null)
                this.m_CustomParser = new CustomParser(customParser);
            //custom toString
            XmlNode customToString = node[CustomToString.NodeName];
            if (customToString != null)
                this.m_CustomToString = new CustomToString(customToString);
        }

        private void registerReferencedObject(ObjectReferenceLoadCache cache)
        {
            cache.ReferencedObjects.Add(this.id, this);
        }

        public static new string NodeName = "InformationSubElement";

        internal void Compile(System.CodeDom.CodeTypeDeclaration subElementClass)
        {
            subElementClass.Name = this.name.Replace(" ", "_");
            subElementClass.BaseTypes.Add("InformationSubElement");
            
            //default konstruktor                                   
            CodeConstructor constructor1 = new CodeConstructor();
            constructor1.Name = this.name;
            //Assign a name for the method.            
            constructor1.Attributes = MemberAttributes.Public;
            subElementClass.Members.Add(constructor1);
            
            //default konstruktor                                   
            CodeConstructor constructorWithParam = new CodeConstructor();
            constructorWithParam.Name = this.name;
            constructorWithParam.Parameters.Add(new CodeParameterDeclarationExpression("InformationElementBase", "parent_"));
            constructorWithParam.Parameters.Add(new CodeParameterDeclarationExpression("System.Int32", "dataBase_"));
            constructorWithParam.Parameters.Add(new CodeParameterDeclarationExpression("System.Int32", "dataOffset_"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.parent = parent_;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.data = parent_.DataColl;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.dataBase = dataBase_;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.dataOffset = dataOffset_;"));
            constructorWithParam.Statements.Add(new CodeSnippetStatement(
                "\t\t\tthis.ParseData();"));
            //Assign a name for the method.            
            constructorWithParam.Attributes = MemberAttributes.Public;
            subElementClass.Members.Add(constructorWithParam);
            
            //vytvor  premennu value, valuestring                                                  
            CodeMemberField valueStringField = new CodeMemberField(typeof(System.String), "m_valueString");
            valueStringField.StartDirectives.Add(new CodeRegionDirective(CodeRegionMode.Start, "Private Variables"));
            subElementClass.Members.Add(valueStringField);
            valueStringField.EndDirectives.Add(new CodeRegionDirective(CodeRegionMode.End, "Private Variables"));

            
            //vytvor public interface pre premenne            
            CodeMemberProperty lenField = new CodeMemberProperty();
            lenField.Name = "Length";
            lenField.Type = new CodeTypeReference(typeof(int));
            lenField.Attributes = MemberAttributes.Public | MemberAttributes.Override;
            lenField.StartDirectives.Add(new CodeRegionDirective(CodeRegionMode.Start, "Public Interface"));
            //Add the property to the class
            subElementClass.Members.Add(lenField);
            //Add the code snippets into the property
            CodeSnippetExpression getsnippetLen = new CodeSnippetExpression("return " + this.Length);
            lenField.GetStatements.Add(getsnippetLen);            

            CodeMemberProperty valueStringProperty = new CodeMemberProperty();
            valueStringProperty.Name = "ValueString";
            valueStringProperty.Type = new CodeTypeReference(typeof(System.String));
            valueStringProperty.Attributes = (MemberAttributes.Public & MemberAttributes.AccessMask);
            //Add the property to the class
            subElementClass.Members.Add(valueStringProperty);
            //Add the code snippets into the property
            CodeSnippetExpression getsnippet2 = new CodeSnippetExpression("return m_valueString");
            valueStringProperty.GetStatements.Add(getsnippet2);
            valueStringProperty.EndDirectives.Add(new CodeRegionDirective(CodeRegionMode.End, "Public Interface"));
            

            //vytvor funkciu parsedata            
            CodeMemberMethod parseDataMethod = new CodeMemberMethod();
            //Assign a name for the method.
            parseDataMethod.Name = "ParseData";
            subElementClass.Members.Add(parseDataMethod);

            if (this.CustomParser == null)
            {
                //treba pripravit hodnotu pre parser
                //TODO: poriesit ak je value na viac bajtov
                //if (this.m_length > 0)
                //{
                    parseDataMethod.Statements.Add(
                        new CodeSnippetStatement("\t\t\tthis.setDataValue();"));
                //}
                //else
                //{
                //    parseDataMethod.Statements.Add(
                //        new CodeSnippetStatement("\t\t\tthis.m_value = 0;"));
                //}
                //usporiadaj meaningy
                this.m_meanings.Sort(Meaning.OrderByValue);
                //skompiluj meaningy
                foreach (var item in this.m_meanings)
                {
                    item.Compile(subElementClass, parseDataMethod);                
                }                
            }
            else
            {
                //ma vlastny parser
                //nakopiruj obsah do funckie parsedata 
                this.CustomParser.Compile(subElementClass, parseDataMethod);
            }

            //vytvor funkciu parsedata            
            CodeMemberMethod toStringMethod = new CodeMemberMethod();
            //Assign a name for the method.
            toStringMethod.Name = "ToString";
            toStringMethod.Attributes = MemberAttributes.Public | MemberAttributes.Override;
            toStringMethod.ReturnType = new CodeTypeReference("System.String");
            subElementClass.Members.Add(toStringMethod);

            if (this.CustomToString == null)
            {
                CodeSnippetStatement val;
                //treba nakopirovat vseobecny tostring ktory vypise value
                switch (this.m_type)
                {
                    default:
                    case Type.Text:
                        val = new CodeSnippetStatement("\t\t\treturn this.ValueString;");
                        break;
                    case Type.Value:
                        val = new CodeSnippetStatement("\t\t\treturn this.Value.ToString();");
                        break;                                            
                }                
                toStringMethod.Statements.Add(val);
            }
            else
            {
                toStringMethod.Statements.Add(new CodeSnippetStatement(
                    this.CustomToString.Function));
            }

        }
    }
}
