﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.CodeDom;

namespace MetaModel.Model.DataSets
{
    public class SequenceChild : ObjectBase
    {
        int m_seqNr;
        ISequenceChild m_child;

        public SequenceChild()
        { }
        public SequenceChild(XmlNode node)
            : base(node)
        { }
        public SequenceChild(ISequenceChild child)
        {
            this.m_child = child;
        }
        public SequenceChild(int seqNr, ISequenceChild child)
            : this(child)
        {
            this.m_seqNr = seqNr;
        }

        public int SequenceNumber
        {
            get { return m_seqNr; }
            set { m_seqNr = value; }
        }
        public ISequenceChild Child
        {
            get { return m_child; }
            set { m_child = value; }
        }

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(SequenceChild.NodeName);

            //SequenceNumber .. povinne
            XmlAttribute nrAttr = parentDoc.CreateAttribute("SequenceNumber");
            nrAttr.Value = this.m_seqNr.ToString();
            this.currentNode.Attributes.Append(nrAttr);

            if (this.m_child != null)
                this.m_child.SaveToXml(this.currentNode);

            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);
        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //SequenceNumber .. povinne
            XmlAttribute nrAttr = node.Attributes["SequenceNumber"];
            if (nrAttr != null)
                this.m_seqNr = int.Parse(nrAttr.Value);

            //Item
            XmlNode childNode = node[Item.NodeName];
            if (childNode != null)
                this.m_child = new Item(childNode);
            //Choice
            XmlNode choiceNode = node[Choice.NodeName];
            if (choiceNode != null)
                this.m_child = new Choice(choiceNode);
        }
        public static new string NodeName = "SequenceChild";

        public static int CompareBySeqNr(SequenceChild a, SequenceChild b)
        {
            return a.m_seqNr.CompareTo(b.m_seqNr);
        }

        internal void GetReferencedObjects(MetaModel.Compiler.CompileInfo info)
        {
            if (this.m_child != null && this.m_child is Choice)
                (this.m_child as Choice).GetReferencedObjects(info);
        }

        public void Compile(
            CodeStatementCollection parseFunction,
            MetaModel.Compiler.CompileInfo info,
            CodeTypeMemberCollection localVariablesCollection)
        {
            if (this.m_child != null)
                this.m_child.Compile(parseFunction, info, localVariablesCollection);
        }
    }
}
