﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace MetaModel.Model.DataSets
{
    public class ObjectReference : ObjectBase
    {
        public static new string NodeName = "ObjectReference";
        ObjectBase m_referencedObject = null;
        Guid m_referencedGuid;

        public ObjectReference()
        { }
        public ObjectReference(XmlNode node)
            : base(node)
        { }
        public ObjectReference(ObjectBase referencedObject)
        {
            this.m_referencedObject = referencedObject;
        }

        public Guid ReferencedGuid
        {
            get
            {
                if (this.m_referencedObject != null)                
                    this.m_referencedGuid = this.m_referencedObject.Id;
                
                return m_referencedGuid;
            }
            set { m_referencedGuid = value; }
        }
        public ObjectBase ReferencedObject
        {
            get { return m_referencedObject; }
            set { m_referencedObject = value; }
        }

        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            XmlAttribute refAttr = parentDoc.CreateAttribute(ObjectReference.NodeName);
            refAttr.Value = this.m_referencedObject.Id.ToString("B");
            parentNode.Attributes.Append(refAttr);
        }
        public override void LoadFromXml(XmlNode node)
        {
            ObjectReferenceLoadCache.RegisterReference += this.registerReference;
            XmlAttribute idAttr = this.currentNode.Attributes[ObjectReference.NodeName];
            if (idAttr != null)
            {
                this.m_referencedGuid = new Guid(idAttr.Value);
            }
        }
        private void registerReference(ObjectReferenceLoadCache cache)
        {
            cache.References.Add(this);
        }

        public void ParseReference(ObjectReferenceLoadCache cache)
        {
            if (this.m_referencedGuid != null)
            {
                if (cache.ReferencedObjects.ContainsKey(this.m_referencedGuid))
                    this.m_referencedObject = cache.ReferencedObjects[this.m_referencedGuid];
            }
        }
    }
}
