﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace MetaModel.Model.DataSets
{
    public class LengthInstance : ObjectBase
    {
        ObjectReference m_reference;
        String m_subReference;

        public LengthInstance()
        { }
        public LengthInstance(XmlNode node)
            :base(node)
        { }

        public ObjectReference Reference
        {
            get { return m_reference; }
            set { m_reference = value; }
        }
        public String SubReference
        {
            get { return m_subReference; }
            set { m_subReference = value; }
        }

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(LengthInstance.NodeName);
            parentNode.AppendChild(this.currentNode);
     
            //reference
            if (this.m_reference != null)
                this.m_reference.SaveToXml(this.currentNode);
            //sub reference
            if (this.m_subReference != null && this.m_subReference != string.Empty)
            {
                XmlNode subRefNd = parentDoc.CreateElement("SubReference");
                subRefNd.InnerText = this.m_subReference;
                this.currentNode.AppendChild(subRefNd);
            }           
        }

        public override void LoadFromXml(System.Xml.XmlNode node)
        {            
            //Ref .. povinne
            XmlAttribute refAttr = node.Attributes[ObjectReference.NodeName];
            if (refAttr != null)
                this.m_reference = new ObjectReference(node);

            //SubReference
            XmlNode subRefNd = node["SubReference"];
            if (subRefNd != null)
                this.m_subReference = subRefNd.InnerText; 
        }
        public static new string NodeName = "LengthInstance";
    }
}
