﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.CodeDom;
using MetaModel.Compiler;
using MetaModel.Model.InformationSubElementNs;

namespace MetaModel.Model.DataSets
{
    public class Item : ObjectBase, ISequenceChild
    {
        ObjectReference m_reference;        
        String c_menoLokalnejPremennej = "m_";

        public Item()
        { }
        public Item(XmlNode node)
            : base(node)
        { }
        public Item(string name_, ObjectBase referencedObj)
        {
            this.id = Guid.NewGuid();
            this.name = name_;
            this.m_reference = new ObjectReference(referencedObj);
        }

        #region Public interface
        public ObjectReference Reference
        {
            get { return m_reference; }
            set { m_reference = value; }
        }
        public String Name
        {
            get { return name; }
            set { name = value; }
        }
        public String MenoLokalnejPremennej
        {
            get { return c_menoLokalnejPremennej; }
        }
        #endregion

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Item.NodeName);
            parentNode.AppendChild(this.currentNode);

            //Id            
            this.SaveId(parentDoc);
            //reference
            if (this.m_reference != null)
                this.m_reference.SaveToXml(this.currentNode);
            //name
            if (this.name != null && this.name != string.Empty)
            {
                XmlAttribute nameAttr = parentDoc.CreateAttribute("Name");
                nameAttr.Value = this.name;
                this.currentNode.Attributes.Append(nameAttr);
            }

        }
        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            //Id .. povinne
            XmlAttribute idAttr = node.Attributes["Id"];
            if (idAttr != null)
            {
                this.id = new Guid(idAttr.Value);
                ObjectReferenceLoadCache.RegisterReferencedObject += this.registerReferencedObject;
            }

            //Ref .. povinne
            XmlAttribute refAttr = node.Attributes[ObjectReference.NodeName];
            if (refAttr != null)
                this.m_reference = new ObjectReference(node);

            //Meno
            XmlAttribute menoAttr = node.Attributes["Name"];
            if (menoAttr != null)
                this.name = menoAttr.Value;
        }
        public static new string NodeName = "Item";
        private void registerReferencedObject(ObjectReferenceLoadCache cache)
        {
            cache.ReferencedObjects.Add(this.id, this);
        }

        public void Compile(
            CodeStatementCollection parseFunction,
            CompileInfo info,
            CodeTypeMemberCollection localVariablesCollection)
        {
            //vytvori premennu a prida ju do zoznamu items  
            IDataChild refObj = this.Reference.ReferencedObject as IDataChild;
            string typ = refObj.Parent.Namespace + "." + refObj.Name.Replace(" ", "_");
            //meno docasnej premennej
            string menoTmp = "tmp_";
            if (this.name != null || this.name != string.Empty)
                menoTmp += this.name.Replace(" ", "_");
            else
                menoTmp += this.Reference.ReferencedObject.Name.Replace(" ", "_");            
            
            //vytvor si pomocnu premennu                      
            parseFunction.Add(
                new CodeSnippetStatement("\t\t\t" + typ + " " + menoTmp + ";"));            
            //this.pageMode = new PageMode(this, tmp_dataBase, tmpDataOffset);
            parseFunction.Add(
                new CodeSnippetStatement("\t\t\t" + menoTmp + " = new " + typ + "(this, tmpBase, tmpOffset);"));
            parseFunction.Add(
               new CodeSnippetStatement("\t\t\tthis.addLength(ref tmpBase, ref tmpOffset, ref tmpLength, " + menoTmp + ");"));
            //pridaj objekt do zoznamu itemov
            parseFunction.Add(
                new CodeSnippetStatement("\t\t\tthis.items.Add(\"" + this.name + "\", " + menoTmp + ");"));

            //ak som referencovany v nejakej podmienke tak ma pridaj ako global premennu
            if (info.ReferencedObjectList.Contains<Guid>(this.id))
            {
                this.CompileCreateLocalVariable(localVariablesCollection);
                parseFunction.Add(
                    new CodeSnippetStatement("\t\t\tthis." + this.c_menoLokalnejPremennej + " = " + menoTmp + ";"));
            }

            parseFunction.Add(
                new CodeCommentStatement("..."));

        }

        public void CompileCreateLocalVariable(CodeTypeMemberCollection localVariablesCollection)
        {
            //vytvori lokalnu premennu
            IDataChild refObj = this.Reference.ReferencedObject as IDataChild;
            string typ = refObj.Parent.Namespace + "." + refObj.Name.Replace(" ", "_");

            if (this.name != null || this.name != string.Empty)
                this.c_menoLokalnejPremennej += this.name.Replace(" ", "_");
            else
                this.c_menoLokalnejPremennej += this.Reference.ReferencedObject.Name.Replace(" ", "_");
            CodeMemberField valueField = new CodeMemberField(typ, this.c_menoLokalnejPremennej);
            localVariablesCollection.Add(valueField);

        }
    }
}
