﻿using System;
using System.Xml;

namespace MetaModel.Model.DataSets
{
    public class CyclicCondition : ObjectBase
    {
         String m_function;

        public CyclicCondition()
        { }
        public CyclicCondition(String function)
        {
            this.m_function = function;
        }
        public CyclicCondition(XmlNode node)
            : base(node)
        { }

        public String Function
        {
            get { return m_function; }
            set { m_function = value; }
        }

        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(CyclicCondition.NodeName);
            //ulozim kod
            this.currentNode.InnerText = this.m_function;
        }
        public override void LoadFromXml(XmlNode node)
        {
            this.m_function = node.InnerText;
        }

        public static new string NodeName = "CyclicCondition";
    }
}
