﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.CodeDom;

namespace MetaModel.Model.DataSets
{
    public class Children : ObjectBase
    {
        IChild m_child;

        public Children()
        { }
        public Children(XmlNode node)
            : base(node)
        { }

        public IChild Child
        {
            get { return m_child; }
            set { m_child = value; }
        }

        public override void SaveToXml(System.Xml.XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Children.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //condition
            if (this.m_child != null)
                this.m_child.SaveToXml(this.currentNode);
        }

        public override void LoadFromXml(System.Xml.XmlNode node)
        {
            XmlNode sequenceNode = node[Sequence.NodeName];
            if (sequenceNode != null)
                this.m_child = new Sequence(sequenceNode);

            XmlNode choiceNode = node[Choice.NodeName];
            if (choiceNode != null)
                this.m_child = new Choice(choiceNode);

        }
        public static new string NodeName = "Children";

        internal void GetReferencedObjects(Compiler.CompileInfo info)
        {
            if (this.m_child != null)
                this.m_child.GetReferencedObjects(info);
        }

        public void Compile(
           CodeStatementCollection parseFunction,
           MetaModel.Compiler.CompileInfo info,
           CodeTypeMemberCollection localVariablesCollection)
        {
            if (this.m_child != null)
                this.m_child.Compile(parseFunction, info, localVariablesCollection);
        }
    }
}
