﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Runtime.Remoting.Metadata.W3cXsd2001;

namespace MetaModel.Model.DataSets
{
    public class Case : ObjectBase
    {
        Children m_children;
        byte[] m_value = null;

        public Case()
        {
            this.m_children = new Children();
        }
        public Case(XmlNode node)
            : base(node)
        { }
        public Case(string value)
        {            
            SoapHexBinary hexBinary = SoapHexBinary.Parse(value);
            this.m_value = hexBinary.Value;
            this.m_children = new Children();
        }

        public Children Children
        {
            get { return m_children; }
            set { m_children = value; }
        }
        public byte[] Value
        {
            get { return m_value; }
            set { m_value = value; }
        }
        public String ValueString
        {
            get
            {
                StringBuilder sb = new StringBuilder();
                foreach (var item in this.m_value)
                {
                    sb.Append(item.ToString() + ", ");
                }
                sb.Remove(sb.Length - 2, 2);
                return sb.ToString();
            }

        }
		public String ValueRenderString
		{
			get
			{
				if (this.Value == null) return "Default";
				SoapHexBinary hexBinary = new SoapHexBinary(this.Value);
				return hexBinary.ToString();				
			}
		}

        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Case.NodeName);
            parentNode.AppendChild(this.currentNode);

            //Id            
            //this.SaveId(parentDoc);
            //value
            if (this.m_value != null)
            {
                XmlAttribute valueAttr = parentDoc.CreateAttribute("Value");
                SoapHexBinary hexBinary = new SoapHexBinary(this.m_value);
                valueAttr.Value = hexBinary.ToString();
                this.currentNode.Attributes.Append(valueAttr);
            }

            //children
            if (this.m_children != null)
                this.m_children.SaveToXml(this.currentNode);
        }
        public override void LoadFromXml(XmlNode node)
        {
            //Id .. povinne
            //XmlAttribute idAttr = node.Attributes["Id"];
            //if (idAttr != null)
            //    this.id = new Guid(idAttr.Value);

            //Value
            XmlAttribute valueAttr = node.Attributes["Value"];
            if (valueAttr != null)
            {
                SoapHexBinary hexBinary = SoapHexBinary.Parse(valueAttr.Value);
                this.m_value = hexBinary.Value;
            }

            XmlNode childNode = node[Children.NodeName];
            if (childNode != null)
                this.m_children = new Children(childNode);
        }
        public static new string NodeName = "Case";

        internal void GetReferencedObjects(MetaModel.Compiler.CompileInfo info)
        {
            if (this.m_children != null)
                this.m_children.GetReferencedObjects(info);
        }

        public static int OrderByValue(Case a, Case b)
        {
            if (a.m_value == null || b.m_value == null)
            {
                if (a.m_value == null && b.m_value == null)
                    return 0;
                else if (a.m_value == null)
                    return 1;
                else if (b.m_value == null)
                    return -1;
            }
            //oba maju hodnotu
            return 0;// (int)(a.m_value - b.m_value);
        }
    }
}
