﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MetaModel.Model.InformationSubElementNs;
using System.Xml;
using MetaModel.Model.InformationElementNs;

namespace MetaModel.Model
{
    public class Data : ObjectBase
    {
        String m_namespace;
        List<InformationSubElement> m_subElements = new List<InformationSubElement>();
        List<InformationElement> m_Elements = new List<InformationElement>();

        public Data()
        { }
        public Data(XmlNode node)
            : base(node)
        { }

        public String Namespace
        {
            get { return m_namespace; }
            set { m_namespace = value; }
        }
        public List<InformationSubElement> SubElements
        {
            get { return m_subElements; }
            set { m_subElements = value; }
        }
        public List<InformationElement> Elements
        {
            get { return m_Elements; }
            set { m_Elements = value; }
        }

        public void AddSubElement(InformationSubElement elem)
        {
            this.m_subElements.Add(elem);
            elem.Parent = this;
        }
        public void AddElement(InformationElement elem)
        {
            this.m_Elements.Add(elem);
            elem.Parent = this;
        }

        public override void SaveToXml(XmlNode parentNode)
        {
            XmlDocument parentDoc = parentNode.OwnerDocument;
            this.currentNode = parentDoc.CreateElement(Data.NodeName);
            //pripojim sa k rodicovi
            parentNode.AppendChild(this.currentNode);

            //Namespace .. povinne
            XmlAttribute nsAttr = parentDoc.CreateAttribute("Namespace");
            nsAttr.Value = this.m_namespace;
            this.currentNode.Attributes.Append(nsAttr);

            //ulozim subElements
            foreach (var item in this.m_subElements)
                item.SaveToXml(this.currentNode);
            //ulozim Elements
            foreach (var item in this.m_Elements)
                item.SaveToXml(this.currentNode);
                       
        }
        public override void LoadFromXml(XmlNode node)
        {
            //namespace .. povinne
            XmlAttribute nsAttr = node.Attributes["Namespace"];
            if (nsAttr != null)
                this.m_namespace = nsAttr.Value;
            
            //subElements
            XmlNodeList subElements = node.SelectNodes(InformationSubElement.NodeName);
            foreach (XmlNode item in subElements)
                this.m_subElements.Add(new InformationSubElement(item, this));

            //Elements
            XmlNodeList elements = node.SelectNodes(InformationElement.NodeName);
            foreach (XmlNode item in elements)
                this.m_Elements.Add(new InformationElement(item, this)); 
        }
      
        public static new string NodeName = "Data";
    }
}
