﻿using System;
using System.CodeDom;
using System.CodeDom.Compiler;
using System.Collections.Generic;
using System.IO;
using MetaModel.Model;

namespace MetaModel.Compiler
{
    public class Compiler
    {
        List<ProtocolModel> m_models = new List<ProtocolModel>();
        String codeDir;
        String assemblyName;
        List<String> compilerParams = new List<string>();
        List<String> referencedAssemblies = new List<String>();

        public List<String> ReferencedAssemblies
        {
            get { return referencedAssemblies; }
            set { referencedAssemblies = value; }
        }
        public List<String> CompilerParams
        {
            get { return compilerParams; }
            set { compilerParams = value; }
        }
        public String CodeDir
        {
            get { return codeDir; }
            set { codeDir = value; }
        }
        public String AssemblyName
        {
            get { return assemblyName; }
            set { assemblyName = value; }
        }
        public List<ProtocolModel> Models
        {
            get { return m_models; }
            set { m_models = value; }
        }

        public Compiler()
        {
            this.compilerParams.Add("mscorlib.dll");
            this.compilerParams.Add("ObjectModel.dll");

            this.referencedAssemblies.Add("System.dll");
        }

        public void Compile()
        {
            if (this.m_models.Count == 0)
                return;


            Microsoft.CSharp.CSharpCodeProvider ccp = new Microsoft.CSharp.CSharpCodeProvider();
            CodeGeneratorOptions o = new CodeGeneratorOptions();
            o.BlankLinesBetweenMembers = false;
            o.BracingStyle = "C";
            o.IndentString = "\t";

            List<String> codeFiles = new List<string>();

            foreach (var model in this.m_models)
            {
                foreach (var item in model.Data.SubElements)
                {
                    CodeCompileUnit compileUnit = CreateCompileUnit(model);
                    CodeNamespace ns = compileUnit.Namespaces[0];
                    //vytvor kod
                    CodeTypeDeclaration subElementClass = new CodeTypeDeclaration();
                    ns.Types.Add(subElementClass);
                    item.Compile(subElementClass);

                    //uloz kod
                    String codePath = Path.Combine(this.codeDir, model.Data.Namespace + "." + item.Name + ".cs");
                    if (!(codeFiles.Contains(codePath)))
                        codeFiles.Add(codePath);
                    TextWriter writer = new StreamWriter(codePath);
                    ccp.GenerateCodeFromCompileUnit(compileUnit, writer, o);

                    writer.Flush();
                    writer.Close();
                }

                foreach (var item in model.Data.Elements)
                {
                    CodeCompileUnit compileUnit = CreateCompileUnit(model);
                    CodeNamespace ns = compileUnit.Namespaces[0];
                    //vytvor kod
                    CodeTypeDeclaration elementClass = new CodeTypeDeclaration();
                    ns.Types.Add(elementClass);
                    item.Compile(elementClass);

                    //uloz kod
                    String codePath = Path.Combine(this.codeDir, model.Data.Namespace + "." + item.Name + ".cs");
                    if (!(codeFiles.Contains(codePath)))
                        codeFiles.Add(codePath);
                    TextWriter writer = new StreamWriter(codePath);
                    ccp.GenerateCodeFromCompileUnit(compileUnit, writer, o);

                    writer.Flush();
                    writer.Close();
                }
            }
            //skompiluj 
            if (this.assemblyName != null)
            {
                //Add the following compiler parameters. (The references to the //standard .net dll(s) and framework library).
                CompilerParameters comparam = new CompilerParameters(this.compilerParams.ToArray());
                comparam.ReferencedAssemblies.AddRange(this.referencedAssemblies.ToArray());
                //Indicates Whether the compiler has to generate the output in //memory
                comparam.GenerateInMemory = false;
                //Indicates whether the output is an executable.
                comparam.GenerateExecutable = false;
                //comparam.IncludeDebugInformation = true;
                comparam.CompilerOptions = "/optimize";
                comparam.IncludeDebugInformation = true;

                comparam.TreatWarningsAsErrors = false;
                comparam.WarningLevel = 0;

                //provide the path where the generated assembly would be placed 
                comparam.OutputAssembly = this.assemblyName;
                CompilerResults cr = ccp.CompileAssemblyFromFile(comparam, codeFiles.ToArray());

                if (cr.Errors.Count > 0)
                {
                    // Display compilation errors.
                    Console.WriteLine("Errors building {0}", cr.PathToAssembly);
                    foreach (CompilerError ce in cr.Errors)
                    {
                        Console.WriteLine("  {0}", ce.ToString());
                        Console.WriteLine();
                    }
                }
                else
                {
                    Console.WriteLine("Build OK");
                }

            }
        }

        private CodeCompileUnit CreateCompileUnit(ProtocolModel model)
        {
            CodeCompileUnit compileUnit = new CodeCompileUnit();

            CodeNamespace ns = new CodeNamespace(model.Data.Namespace);
            compileUnit.Namespaces.Add(ns);
            ns.Imports.Add(new CodeNamespaceImport("ObjectModel.InformationElements"));
            ns.Imports.Add(new CodeNamespaceImport("System"));
            ns.Imports.Add(new CodeNamespaceImport("System.Collections.Generic"));
            ns.Imports.Add(new CodeNamespaceImport("System.Text"));
            return compileUnit;
        }



    }
}
