﻿using System;
using AnalyzeThisForms.Components;
using Loaders.IQLoader.ProviderInterfaces;
using ObjectModel.Protocols;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader.ProviderBases
{
    /// <summary>
    /// Bazova trida pro vytvareni Protocol provideru.
    /// </summary>
    public abstract class ProtocolProviderBase : IProtocolProvider
    {
        /// <summary>
        /// Nastaveni celeho pluginu.
        /// </summary>
        protected PluginSettings settings;

        /// <summary>
        /// Reference na Demodulation Provider.
        /// </summary>
        protected IDemodulationProvider demodProvider;

        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="settings">Nastaveni pluginu.</param>
        /// <param name="demodProvider">Reference na pouzity Demodulaion provider.</param>
        /// <exception cref="ArgumentNullException">Pokud je nektery z parametru null.</exception>
        /// <exception cref="ProviderInitializationException">Pokud doslo pri inicializaci provideru k chybe.</exception>
        public ProtocolProviderBase(PluginSettings settings, IDemodulationProvider demodProvider)
        {
            if (settings == null || demodProvider == null)
                throw new ArgumentNullException("Nektery parametr nebyl zadan");
            this.settings = settings;
            this.demodProvider = demodProvider;
        }

        /// <summary>
        /// Vraci nazev protokolu.
        /// </summary>
        /// <returns>Vraci nazev protokolu.</returns>
        public static string getProtocolName()
        {
            throw new NotImplementedException("getProtocolName not implemented.");
        }

        /// <summary>
        /// Vraci typ modulace pozadovany timto protokolem.
        /// </summary>
        /// <returns>Vraci typ modulace pozadovany timto protokolem.</returns>
        public static EModulationType getModulationType()
        {
            throw new NotImplementedException("getModulationType not implemented.");
        }

        /// <summary>
        /// Vraci sirku pasma pouzitou pro dany protokol. Ma spise informativni vyznam.
        /// </summary>
        /// <returns>Vraci sirku pasma pouzitou pro dany protokol.</returns>
        public static float getBandwidth()
        {
            throw new NotImplementedException("getModulationType not implemented.");
        }

        /// <summary>
        /// Vraci dalsi datovy ramec ze vstupniho proudu dat.
        /// </summary>
        /// <returns>Vraci dalsi datovy ramec ze vstupniho proudu dat.</returns>
        /// <exception cref="EndOfStreamException">Pokud je dosazeno konce vstupnich dat.</exception>  
        public abstract byte[] getDataFrame();

        /// <summary>
        /// Vraci protocol factory pro dany protokol.
        /// </summary>
        /// <param name="info_">Objekt obsahujici definici ruznych analyzovatelnych protokolu.</param>
        /// <returns>Vraci protocol factory pro dany protokol.</returns>
        public abstract ProtocolFactoryBase getProtocolFactory(ProgramInfo info_);
    }
}
