﻿using System;
using Loaders.IQLoader.ProviderInterfaces;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader.ProviderBases
{
    /// <summary>
    /// Bazova trida pro vytvareni Filter provideru.
    /// </summary>
    public abstract class FilterProviderBase : IQDataProvider
    {
        /// <summary>
        /// Nastaveni celeho pluginu.
        /// </summary>
        protected PluginSettings settings;

        /// <summary>
        /// Reference na Data Provider.
        /// </summary>
        protected IQDataProvider dataProvider;

        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="settings">Nastaveni pluginu.</param>
        /// <param name="dataProvider">Reference na pouzity data provider.</param>
        /// <exception cref="ArgumentNullException">Pokud je nektery z parametru null.</exception>    
        /// <exception cref="ProviderInitializationException">Pokud doslo pri inicializaci provideru k chybe.</exception>
        public FilterProviderBase(PluginSettings settings, IQDataProvider dataProvider)
        {
            if (settings == null || dataProvider == null)
                throw new ArgumentNullException("Nektery z parametru nebyl zadan.");
            this.dataProvider = dataProvider;
            this.settings = settings;
        }

        /// <summary>
        /// Jmeno filtru.
        /// </summary>
        /// <returns>Vraci jmeno filtru.</returns>
        public static string getFilterName()
        {
            throw new System.NotImplementedException("getFilterName() nebylo implementovano.");
        }

        #region IQDataProvider Members

        /// <summary>
        /// Vraci dalsi I/Q bod ze vstupniho proudu.
        /// </summary>
        /// <returns>Vraci dalsi I/Q bod ze vstupniho proudu.</returns>
        /// <exception cref="EndOfStreamException">Pokud je dosazeno konce vstupnich dat.</exception>
        public abstract IQData getIQPoint();

        #endregion
    }
}
