﻿using System;
using Loaders.IQLoader.ProviderInterfaces;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader.ProviderBases
{
    /// <summary>
    /// Bazova trida pro tvorbu Demodulation Provideru.
    /// </summary>
    public abstract class DemodulationProviderBase : IDemodulationProvider
    {
        /// <summary>
        /// Nastaveni celeho pluginu.
        /// </summary>
        protected PluginSettings settings;

        /// <summary>
        /// Reference na filter provider.
        /// </summary>
        protected IQDataProvider filterProvider;

        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="settings">Nastaveni pluginu.</param>
        /// <param name="filterProvider">Instance filter provideru.</param>
        /// <exception cref="ArgumentNullException">Pokud je nektery z parametru null.</exception>        
        public DemodulationProviderBase(PluginSettings settings, IQDataProvider filterProvider)
        {
            if (settings == null || filterProvider == null)
                throw new ArgumentNullException("Nektery parametr nebyl zadan.");
            this.settings = settings;
            this.filterProvider = filterProvider;
        }

        /// <summary>
        /// Vraci nazev provideru.
        /// </summary>
        /// <returns>Vraci nazev provideru.</returns>
        public static string getDemodName()
        {
            throw new NotImplementedException("getDemodName not implemented.");
        }

        /// <summary>
        /// Vraci typ modulace.
        /// </summary>
        /// <returns>Vraci typ modulace.</returns>
        public static EModulationType getModulationType()
        {
            throw new NotImplementedException("getModulationType() nebylo implementovano.");
        }

        #region IDemodulationProvider Members
        /// <summary>
        /// Vraci binarni vzorek demodulovany ze vstupnich dat.
        /// </summary>
        /// <returns>Logicka jedna nebo nula (neodpovida bitove synchronizaci).</returns>
        /// <exception cref="EndOfStreamException">V pripade dosazeni konce dat.</exception>   
        public abstract byte getBit();

        #endregion
    }
}
