﻿using Loaders.IQLoader.ProviderInterfaces;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader.ProviderBases
{
    /// <summary>
    /// Vychozi trida pro tvorbu data provideru.
    /// </summary>
    public abstract class DataProviderBase : IQDataProvider
    {
        /// <summary>
        /// Nastaveni celeho pluginu.
        /// </summary>
        private PluginSettings settings;

        /// <summary>
        /// Konstruktor.
        /// </summary>
        /// <param name="settings">Instance Plugin settings.</param>
        /// <exception cref="ProviderInitializationException">Pokud doslo pri inicializaci provideru k chybe.</exception>
        public DataProviderBase(PluginSettings settings)
        {
            this.settings = settings;
        }

        /// <summary>
        /// Uzavre zarizeni (napr. soubor) a uvolni vsechny zdroje.
        /// </summary>
        public abstract void CloseDevice();

        /// <summary>
        /// Ziska novy I/Q bod ze vstupniho proudu.
        /// </summary>
        /// <returns>Vraci I/Q bod.</returns>
        /// <exception cref="EndOfStreamException">Pokud je dosazeno konce vstupnich dat.</exception> 
        public abstract IQData getIQPoint();
    }
}
