﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

///
/// (c)2010 Tomas Ocelik
/// xoceli00@fit.vutbr.cz
/// 
/// Vstupni zasuvny modul poskytujici vstup dat ze spektralniho analyzatoru.
///

namespace Loaders.IQLoader.GUI
{
    public partial class Settings : Form
    {
        /// <summary>
        /// Konstruktor urceny pro volani visual studiem.
        /// </summary>
        public Settings()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Konstruktor urceny pro volani pluginem.
        /// </summary>
        /// <param name="settings">Objekt uchovavajici nastaveni pluginu.</param>
        /// <param name="protocolProviderTypes">Seznam nactenych protocol provideru</param>
        /// <param name="demodProviderTypes">Seznam nactenych demod provideru.</param>
        /// <param name="filterProviderTypes">Seznam nactenych filter provideru.</param>
        public Settings(PluginSettings settings,
            Dictionary<string, ProviderInfo> protocolProviderTypes,
            Dictionary<string, ProviderInfo> demodProviderTypes,
            Dictionary<string, ProviderInfo> filterProviderTypes)
        {
            InitializeComponent();
            this.settingsPanel2.SetStructures(settings, protocolProviderTypes, demodProviderTypes, filterProviderTypes);
        }

        private void btnStorno_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            if (this.settingsPanel2.VerifyAndSave())
                this.Close();
        }
    }
}
