﻿using ObjectModel.InformationElements;
using ObjectModel.Protocols;
using AnalyzeThisForms.Components;
using System;

namespace GsmProtocols
{
	public class ProtocolFactory : ProtocolFactoryBase
	{
		public ProtocolFactory(ProgramInfo info_)
		{
			this.info = info_;
		}

		public override void ParseProtocol(InformationElementBase rootProtocol)
		{
			byte switchByte = rootProtocol.DataColl[1];
			switchByte = (byte)(switchByte & 0x0f);
			Object newItem = null;
			String newItemName = null;
			switch (switchByte)
			{
				case 0x06:
					newItemName = "RR";
					newItem = this.info.GetObject("Protocols.GsmTest.RR", rootProtocol, 1, 0);
					break;
				default:
					break;
			}
			if (newItem != null)
				rootProtocol.Items.Add(newItemName, newItem);
		}

		public override string[] ParsedProtocols
		{
			get
			{
				return new string[] { "Protocols.GsmTest.RR", 
				"Protocols.GsmTest.CC", "Protocols.GsmTest.MM" };
			}
		}

		public override string Name
		{
			get { return "Gsm Protocol Factory"; }
		}
	}
}
