﻿using System;
using System.Windows.Forms;
using AnalyzeThisForms.Components;
using ObjectModel.InformationElements;
using ObjectModel.InformationElements.Renderers;
using ObjectModel.Loaders;
using ObjectModel.Protocols;

namespace AnalyzeThisForms
{
	public partial class mainForm : Form
	{
		private ProgramInfo info;
		private LoaderBase m_loader = null;
		public mainForm()
		{
			InitializeComponent();
			this.FormClosing += new FormClosingEventHandler(mainForm_FormClosing);
		}

		public mainForm(ProgramInfo info_)
			: this()
		{
			this.info = info_;
			this.editorMainPanel1.Info = info_;
			this.homePanel1.Info = info_;
			info_.UnloadPravidlaEvent += new UnloadPravidlaEventHandler(info__UnloadPravidlaEvent);
			info_.PravidlaLoadedEvent += new UnloadPravidlaEventHandler(info__PravidlaLoadedEvent);
		}

		void info__PravidlaLoadedEvent()
		{
			this.frameSummary1.Reload();
		}

		void info__UnloadPravidlaEvent()
		{
			this.frameDetailcs1.Clear();
			this.frameSummary1.Clear();
			this.frameSummary1.EndUpdate();
		}

		private void frameSummary1_SelectedIndexChanged(object sender, EventArgs e)
		{
			ListView lv = sender as ListView;
			if (lv.SelectedItems.Count == 0)
				return;

			ListViewItem it = lv.SelectedItems[0];
			if (it.Tag is InformationElementBase)
			{
				InformationElementBase element = it.Tag as InformationElementBase;
				this.frameDetailcs1.RenderFrame(element);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="args">Loader plugin ktory sa pouziva</param>
		private void homePanel1_Clicked_PluginSetiings(object args)
		{
			if (this.m_loader == null)
				m_loader = Activator.CreateInstance(args as Type) as LoaderBase;// this.info.GetLoader("ObjectModel.Loaders.GsmXmlLoader");			

			if (m_loader is ILoaderHasSetupDialog)
				(m_loader as ILoaderHasSetupDialog).SetupDialog();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="args">Loader plugin ktory sa pouziva</param>
		private void homePanel1_Clicked_OpenFile(Object args)
		{
			if (this.m_loader == null)
				m_loader = Activator.CreateInstance(args as Type) as LoaderBase;// this.info.GetLoader("ObjectModel.Loaders.GsmXmlLoader");			          

			if (m_loader.OpenDevice())
			{
				ProtocolFactoryBase factory = m_loader.getProtocolFactory(info);
				this.frameSummary1.Clear();

				InformationElementBase p;
				do
				{
					p = m_loader.GetNextPacket();
					if (p != null && p.DataColl != null)
					{
						this.frameSummary1.AddElement(p, factory);
					}
				} while (p != null);
				m_loader.CloseDevice();

				this.frameSummary1.EndUpdate();

				this.tabControl1.SelectedTab = this.tabViewer;
			}
		}



		private void homePanel1_Clicked_LoadModel(Object args)
		{
			if (this.editorMainPanel1.loadModel())
				this.tabControl1.SelectedTab = this.tabEditor;
		}
		private void homePanel1_Clicked_CompileModel(object args)
		{
			if (this.editorMainPanel1.CompileModel())
				this.tabControl1.SelectedTab = this.tabEditor;
		}

		void mainForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			this.editorMainPanel1.SaveModels();
		}

		private void homePanel1_Clicked_ExportFile(object args)
		{
			IInformationElementRenderer renderer = Activator.CreateInstance(args as Type) as IInformationElementRenderer;
			if (renderer != null)
			{
				if (renderer.SetUp())
				{

					foreach (var item in this.frameSummary1.LoadedElements)
					{
						item.Elem.SetRendererRecursive(renderer);
						item.Elem.RenderData(null);
						item.Elem.RenderInformationElements(0);
					}
					renderer.Close();
					this.tabControl1.SelectedTab = this.tabViewer;
				}
			}
		}



	}
}
