﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AnalyzeThisForms.Panels
{
	public partial class SubPanelBase : UserControl
	{
		protected int oldHeight;
		public SubPanelBase()
		{
			InitializeComponent();
			this.subPanelHeader1.StavChanged += new StavChangedEventHandler(subPanelHeader1_StavChanged);
		}

		void subPanelHeader1_StavChanged(SubPanelHeader.State state)
		{
			switch (state)
			{
				case SubPanelHeader.State.Closed:
					this.Height = this.subPanelHeader1.Height;
					break;
				default:
				case SubPanelHeader.State.Open:
					this.Height = this.oldHeight;
					break;									
			}
		}

		public string HeaderText
		{
			get { return this.subPanelHeader1.HeaderText; }
			set { this.subPanelHeader1.HeaderText = value; }
		}
	}
}
