﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using AnalyzeThisForms.Components;

namespace AnalyzeThisForms.Panels
{
    public delegate void NoArgsEventHandler(Object args);
    public partial class HomePanel : UserControl
    {
        public event NoArgsEventHandler Clicked_OpenFile;
        public event NoArgsEventHandler Clicked_PluginSetiings;
        public event NoArgsEventHandler Clicked_LoadModel;
        public event NoArgsEventHandler Clicked_ExportFile;
        public event NoArgsEventHandler Clicked_CompileModel;
        private ProgramInfo info;

        public ProgramInfo Info
        {
            get { return info; }
            set
            {
                info = value;
                showPlugins();
            }
        }

        public HomePanel()
        {
            InitializeComponent();
        }

        private void showPlugins()
        {
            if (this.info == null) return;
            this.listView1.BeginUpdate();
            this.listView1.Items.Clear();
            foreach (var item in this.info.LoaderTypes)
            {
                ListViewItem it = new ListViewItem();
                it.ImageIndex = 0;
                it.Tag = item.Value;
                it.Text = item.Key;
                this.listView1.Items.Add(it);
            }
            if (listView1.Items.Count > 0)
                this.listView1.Items[0].Selected = true;
            this.listView1.EndUpdate();

            this.listView2.BeginUpdate();
            this.listView2.Items.Clear();
            foreach (var item in this.info.OutputPlugins)
            {
                ListViewItem it = new ListViewItem();
                it.ImageIndex = 1;
                it.Tag = item.Value;
                it.Text = item.Key;
                this.listView2.Items.Add(it);
            }
            if (listView2.Items.Count > 0)
                this.listView2.Items[0].Selected = true;
            this.listView2.EndUpdate();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //pluginSettings
            if (this.Clicked_PluginSetiings != null)
            {
                if (this.listView1.SelectedItems.Count > 0)
                    this.Clicked_PluginSetiings(this.listView1.SelectedItems[0].Tag);
                else
                    MessageBox.Show("Nebyl zvolen žádný vstupní zásuvný modul.", "AnalyzeThis", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void linkLabel3_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //load model
            if (this.Clicked_LoadModel != null)
                this.Clicked_LoadModel(null);
        }


        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            // export data
            if (this.Clicked_ExportFile != null)
            {
                if (this.listView2.SelectedItems.Count > 0)
                    this.Clicked_ExportFile(this.listView2.SelectedItems[0].Tag);
                else
                    MessageBox.Show("Nebyl zvolen žádný výstupní zásuvný modul.", "AnalyzeThis", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void linkLabel4_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            // compile model
            if (this.Clicked_CompileModel != null)
                this.Clicked_CompileModel(null);
        }

        private void btnGetData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //get data
            if (this.Clicked_OpenFile != null)
            {
                if (this.listView1.SelectedItems.Count > 0)
                    this.Clicked_OpenFile(this.listView1.SelectedItems[0].Tag);
                else
                    MessageBox.Show("Nebyl zvolen žádný vstupní zásuvný modul.", "AnalyzeThis", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
