﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ObjectModel.InformationElements;
using ObjectModel.Protocols;

namespace AnalyzeThisForms.Panels
{
	public partial class FrameSummary : PanelBase
	{
		public event EventHandler SelectedIndexChanged;
		List<ElemFactoryPair> loadedElements = new List<ElemFactoryPair>();

		public FrameSummary()
		{
			InitializeComponent();
			lvSummary_Resize(null, null);
		}

		internal List<ElemFactoryPair> LoadedElements
		{
			get { return loadedElements; }
			set { loadedElements = value; }
		}
	
		private void lvSummary_Resize(object sender, EventArgs e)
		{
			this.columnHeader1.Width = this.lvSummary.Width - 25;
		}

		private void lvSummary_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (this.SelectedIndexChanged != null)
				this.SelectedIndexChanged(sender, e);
		}

		public void AddElement(ObjectModel.InformationElements.InformationElementBase p, ProtocolFactoryBase factory)
		{
			factory.ParseProtocol(p);
			ListViewItem it = new ListViewItem();
			it.ImageIndex = 0;
			it.Text = p.ToString();
			it.Tag = p;
			this.lvSummary.Items.Add(it);
			this.loadedElements.Add(new ElemFactoryPair(p, factory));
		}

		internal void Clear()
		{
			this.lvSummary.BeginUpdate();
			this.lvSummary.Items.Clear();

			foreach (var elem in this.loadedElements)
			{
				List<String> keys = new List<string>();
				foreach (KeyValuePair<string, Object> item in elem.Elem.Items)
					if (item.Value is InformationElementBase)
						keys.Add(item.Key);
				foreach (var key in keys)
					elem.Elem.Items.Remove(key);
			}
		}
		internal void EndUpdate()
		{
			if (this.lvSummary.Items.Count > 0)
				this.lvSummary.Items[0].Selected = true;
			this.lvSummary.EndUpdate();
		}
		internal void Reload()
		{
			this.lvSummary.BeginUpdate();
			foreach (var item in this.loadedElements)
			{
				item.Factory.ParseProtocol(item.Elem);
				ListViewItem it = new ListViewItem();
				it.ImageIndex = 0;
				it.Text = item.Elem.ToString();
				it.Tag = item.Elem;
				this.lvSummary.Items.Add(it);				
			}
			this.EndUpdate();
		}

		internal class ElemFactoryPair
		{
			public InformationElementBase Elem;
			public ProtocolFactoryBase Factory;

			public ElemFactoryPair(InformationElementBase elem, ProtocolFactoryBase f)
			{
				this.Elem = elem;
				this.Factory = f;
			}
		}
	}
}
