﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ObjectModel.InformationElements;
using ObjectModel.InformationElements.Renderers;

namespace AnalyzeThisForms.Panels
{
    public partial class FrameDetailcs : PanelBase, IInformationElementRenderer
    {
        public FrameDetailcs()
        {
            InitializeComponent();
        }

        public void RenderFrame(InformationElementBase element)
        {
            this.tvDetails.BeginUpdate();
            this.tvDetails.Nodes.Clear();            
            element.SetRendererRecursive(this);
            element.RenderInformationElements(null);
            element.RenderData(null);
            this.tvDetails.ExpandAll();
            this.tvDetails.EndUpdate();
        }        

        #region IInformationElementRenderer Members

        bool IInformationElementRenderer.SetUp()
        {
			return true;
		}
        void IInformationElementRenderer.Close()
        { }

        void IInformationElementRenderer.RenderInformationElements(InformationElementBase renderedElement, object args)
        {
            TreeNodeCollection collection = this.tvDetails.Nodes;
            if (args is TreeNode)
                collection = (args as TreeNode).Nodes;            

            foreach (KeyValuePair<string, Object> element in renderedElement.Items)
            {
                TreeNode node = new TreeNode();
                StringBuilder sb = new StringBuilder();
                sb.Append(element.Key);
                               
                //ak je to protokol tak ma v sebe information elementy
                if (element.Value is InformationElementBase)
                {
                    InformationElementBase iElement = element.Value as InformationElementBase;
                    //vyrenderuj element pomocou na to urcenej funkcie   
                    node.Tag = iElement;
                    iElement.RenderInformationElements(node);
                }
                else
                {
                    sb.Append(": ");
                    sb.AppendLine(element.Value.ToString());
                }

                node.Text = sb.ToString();
                collection.Add(node);
            }
        }
        void IInformationElementRenderer.RenderData(InformationElementBase renderedElement, object args)
        {
            StringBuilder sb = new StringBuilder();
            int lineCounter = 0, rowCounter = 0;
            foreach (byte item in renderedElement.DataColl.Data)
            {
                //000: 
                if (lineCounter == 0)
                {
                    sb.AppendFormat((rowCounter++).ToString("D3"));
                    sb.Append(": ");
                }
                //01
                sb.AppendFormat(item.ToString("x2"));
                sb.Append(" ");
                lineCounter++;
                if ((lineCounter) % 8 == 0)
                {
                    if (lineCounter % 16 == 0)
                    {
                        sb.AppendLine();
                        lineCounter = 0;
                    }
                    else
                        sb.Append("- ");
                }
            }
            sb.AppendLine();
            //konzola je kontext daneho renderera
            this.tbData.Text = sb.ToString();
        }

        #endregion

		internal void Clear()
		{
			this.tvDetails.BeginUpdate();
			this.tvDetails.Nodes.Clear();
			this.tvDetails.EndUpdate();
		}
	}
}
