﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MetaModel.Model.InformationSubElementNs;

namespace AnalyzeThisForms.Panels.Editor
{
	public partial class SubElementMeaningsGrid : AnalyzeThisForms.Panels.SubPanelBase
	{
		private List<Meaning> loadedMeanings = new List<Meaning>();

		public SubElementMeaningsGrid()
		{
			InitializeComponent();
			base.oldHeight = this.Height;

			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ModelsTree));
			ImageList imageList1 = new System.Windows.Forms.ImageList();
			imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.listView1.SmallImageList = imageList1;
		}
		public new int Height
		{
			get { return base.Height; }
			set
			{
				base.Height = value;
				base.oldHeight = this.Height;
			}
		}

		public void AddAllMeanings(InformationSubElement elem)
		{
			this.listView1.BeginUpdate();
			this.listView1.Items.Clear();
			this.AddMeaning(null);
			foreach (var item in elem.Meanings)
			{
				this.AddMeaning(item);
			}
			this.listView1.EndUpdate();
		}
		public void AddMeaning(Meaning m)
		{
			ListViewItem it = new ListViewItem();
			it.ImageIndex = (int)ModelsTree_Images.Meaning;
			UpdateLvItem(ref m, ref it);
			this.listView1.Items.Add(it);
		}

		public void Save(InformationSubElement elem)
		{
			elem.Meanings = this.loadedMeanings;
		}

		private void UpdateLvItem(ref Meaning m, ref ListViewItem it)
		{
			if (m != null)
			{
				if (m.Value != null)
					it.Text = m.Value.ToString();
				else
				{
					it.Text = "Default";
					it.ForeColor = Color.Green;
				}
				if (it.SubItems.Count == 1)
					it.SubItems.Add(m.Text);
				else
					it.SubItems[1].Text = m.Text;
				if (!(this.loadedMeanings.Contains(m)))
					this.loadedMeanings.Add(m);
			}
			else
			{
				it.SubItems.Add("New Meaning");
				it.ForeColor = Color.Gray;
			}
			it.Tag = m;
		}

		private void listView1_Resize(object sender, EventArgs e)
		{
			this.listView1.Columns[1].Width = this.listView1.Width - this.listView1.Columns[0].Width - 25;
		}

		private void listView1_KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Delete)
			{
				foreach (ListViewItem item in this.listView1.SelectedItems)
				{
					this.loadedMeanings.Remove(item.Tag as Meaning);
					this.listView1.Items.Remove(item);
				}
			}
			else if (e.KeyCode == Keys.Return)
			{
				if (this.listView1.SelectedItems.Count > 0)
				{
					this.ShowSelectedNode();
				}
			}
		}

		private void tbText_KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Return)
			{
				ListViewItem it = this.listView1.SelectedItems[0];
				Meaning m = it.Tag as Meaning;
				if (m == null)
				{
					it = new ListViewItem();
					it.ImageIndex = (int)ModelsTree_Images.Meaning;
					this.listView1.Items.Add(it);
					m = new Meaning();
				}

				m.Text = this.tbText.Text;
				if (this.tbVal.Text == String.Empty || this.tbVal.Text == null)
					m.Value = null;
				else
					m.Value = long.Parse(this.tbVal.Text);

				this.UpdateLvItem(ref m, ref it);
				this.listView1.Show();
			}
		}

		private void ShowSelectedNode()
		{
			ListViewItem it = this.listView1.SelectedItems[0];
			Meaning m = it.Tag as Meaning;
			if (m != null)
			{
				this.tbText.Text = m.Text;
				if (m.Value != null)
					this.tbVal.Text = m.Value.ToString();
				else
					this.tbVal.Clear();
			}
			else
			{
				this.tbVal.Clear();
				this.tbText.Clear();
			}
			this.listView1.Hide();
		}

		private void listView1_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			this.listView1.GetItemAt(e.X, e.Y).Selected = true;
			this.ShowSelectedNode();
		}

	}
}
