﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MetaModel.Model.InformationSubElementNs;

namespace AnalyzeThisForms.Panels.Editor
{
	public partial class SubElementDetail : AnalyzeThisForms.Panels.PanelBase, IEditorChild
	{
		InformationSubElement elem;
		TreeNode node;

		public SubElementDetail()
		{
			InitializeComponent();
			this.loadTypeCombo();
		}

		public SubElementDetail(InformationSubElement elem_, TreeNode node_)
			: this()
		{
			this.elem = elem_;
			this.node = node_;
			this.tbLen.Text = elem_.Length.ToString();
			this.tbName.Text = elem_.Name;
			this.cbType.SelectedItem = elem_.Type;
			this.subElementMeaningsGrid1.AddAllMeanings(elem_);			
		}


		private void loadTypeCombo()
		{
			this.cbType.BeginUpdate();
			this.cbType.Items.Clear();
			foreach (var item in Enum.GetValues(typeof(MetaModel.Model.InformationSubElementNs.Type)))
			{
				this.cbType.Items.Add(item);
			}

			this.cbType.EndUpdate();
		}

		public void Save()
		{
			if (this.elem != null)
			{
				this.elem.Name = this.tbName.Text;
				this.elem.Type = (MetaModel.Model.InformationSubElementNs.Type)this.cbType.SelectedItem;
				this.elem.Length = int.Parse(this.tbLen.Text);
				this.subElementMeaningsGrid1.Save(this.elem);
				if (this.node.Tag is InformationSubElement)
					this.node.Text = this.tbName.Text;
				else
				{
					//je to novy elem
					if (elem.Name.Length > 0)
					{
						//ak ma vyplnene meno, tak je aj platny
						this.elem.Parent.SubElements.Add(this.elem);
						//redraw node paretnNode children
						this.addTreeNode(this.node, this.elem);
					}
				}

			}

		}

		private void addTreeNode(TreeNode treeNode, InformationSubElement informationSubElement)
		{
			TreeNode parentNode = treeNode.Nodes[0];
			treeNode = ModelsTree.CreateSubElementTreeNode(informationSubElement);
			
			//najdi index kam sa ma vlozit
			int i;
			for (i = 0; i < parentNode.Nodes.Count; i++)
			{
				TreeNode nd = parentNode.Nodes[i];
				if (nd.Text.CompareTo(treeNode.Text) > 0) break;
			}
			if (i >= parentNode.Nodes.Count - 1)
				i = Math.Max(0, i - 1);
			parentNode.Nodes.Insert(i, treeNode);

		}

		private void flowLayoutPanel1_SizeChanged(object sender, EventArgs e)
		{
			FlowLayoutPanel pnl = sender as FlowLayoutPanel;
			int sumHeight = 0;
			int wdiff = 6;
			foreach (Control item in pnl.Controls)
			{
				sumHeight += item.Height;
			}
			if (sumHeight > pnl.Height - 5)
				wdiff = 25;

			foreach (Control item in pnl.Controls)
			{
				item.Width = this.flowLayoutPanel1.Width - wdiff;
				item.Invalidate(true);
			}
		
		}

	}
}
