﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MetaModel.Model;
using AnalyzeThisForms.Panels.Editor;

namespace AnalyzeThisForms.Panels
{	
	public delegate void AddProtocolModelEventHandler(ProtocolModel model);
	public partial class ModelDetail : AnalyzeThisForms.Panels.PanelBase, IEditorChild
	{
		private ProtocolModel model;
		private TreeNode node;
		public event AddProtocolModelEventHandler NewProtocol;

		public ModelDetail()
		{
			InitializeComponent();
		}
		public ModelDetail(ProtocolModel model_, TreeNode node_)
			: this()
		{
			this.model = model_;
			this.node = node_;
			this.tbNameSpace.Text = model_.Data.Namespace;
		}
		
		#region IEditorChild Members

		public void Save()
		{
			if (this.model != null)
			{
				this.model.Data.Namespace = this.tbNameSpace.Text;
				if (this.node.Tag is ProtocolModel)
					this.node.Text = this.tbNameSpace.Text;
				else
				{
					//je to novy elem
					if (model.Data.Namespace.Length > 0)
					{												
						//redraw node paretnNode children
						if (this.NewProtocol != null)
							this.NewProtocol(this.model);
					}

				}
			}
		}		

		#endregion
	}
}
