r"""Miscellaneous useful functions"""
__all__=['open_file','get_date']


import os, time, sys


def open_file(file_name):
    r"""
    Opens file named `file_name` and returns filedescriptor.

    If some error is occured. Error message is written to stderr
    and the program is terminated.
    """
    #open files
    try:
        file = open(file_name,'r')
    except IOError as err:
        sys.stderr.write("I/O error: {0}\n".format(err))
        sys.exit(1)

    return file


def get_date(file_name):
    r"""
    Find out date of the last file modification.
    """
    return time.ctime(os.stat(file_name).st_mtime)
