#include <features/CVertexInfo.h>

#undef min
#undef max

#include <limits>

//=====================================================================================================================
CVertexInfo::CVertexInfo( vctl::MCVertex * vertex ) :
        pVertex( vertex )
{
}

//=====================================================================================================================
CVertexInfo::~CVertexInfo()
{
}

//=====================================================================================================================
vctl::MCVertex *    CVertexInfo::getVertex()
{
    return pVertex;
}

//=====================================================================================================================
osg::Vec4   CVertexInfo::getColour()
{
    return osg::Vec4( 1.0, 1.0, 1.0, 1.0 );
}

//=====================================================================================================================
void        CVertexInfo::normalize()
{
}

//=====================================================================================================================
double       CVertexInfo::dMax  =   std::numeric_limits< double >::min();

//=====================================================================================================================
void        CVertexInfo::tryNewMax( double new_max )
{
    dMax = ( ( dMax > new_max ) ? dMax : new_max );
}

//=====================================================================================================================
void         CVertexInfo::clearMax()
{
    CVertexInfo::dMax = std::numeric_limits< double >::min();
}

//=====================================================================================================================
double       CVertexInfo::getMax()
{
    return CVertexInfo::dMax;
}
