#ifndef CSMOOTHER_H
#define CSMOOTHER_H

#include <models/CMesh.h>

#include <base/CCommand.h>

//==============================================================================
/**
 *  Smoother class
 * - base class for all smoothing algorithms
 * - individual smoothers should override the smooth method
 */
class CSmoother : public cmd::CCommand
{
    public :

			//! Smart pointer declaration
            MDS_SHAREDPTR(CSmoother);

    public :

			//! This method smoothes a mesh and implementation should be contained in derived classes
            virtual bool    smooth( CSmoothingMesh * mesh ) = 0;

};

#endif // CSMOOTHER_H
