#ifndef CVERTEXINFO_H
#define CVERTEXINFO_H

// mdstk includz
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsObject.h>
#include <MDSTk/Base/mdsFactory.h>

// vector entity includz
#include <VectorEntity/mctris.h>

// osg includz
#include <osg/Geometry>
#include <osg/Geode>

//==============================================================================
/**
 * Vertex info class
 * - instances represent superclass to a feature that is computed from and stored on vertex
 */
class CVertexInfo : public mds::base::CObject
{
    protected :

            //! Pointer to the associated vertex
            vctl::MCVertex *    pVertex;

    public :

            //! Constructor
            CVertexInfo( vctl::MCVertex * vertex );

            //! Destructor
            virtual ~CVertexInfo();

            //! Returns vertex
            vctl::MCVertex *    getVertex();

            //! Returns vertex colouring
            virtual osg::Vec4   getColour();

            //! Normalizes vertex feature
            virtual void        normalize();

            //! Returns maximal possible value of this feature
            double              getDMax()
            {
                return dMax;
            }

    protected :

			//! Stored maximal value for the whole set of features
            static double       dMax;

    public :

			//! Tries new computed value against old maximum. If succeeds, old value is replaced
            static  void    tryNewMax( double new_max );

			//! Clears old maximum 
            static  void    clearMax();

			//! Returns maximum value
            static  double  getMax();
};

#endif // CVERTEXINFO_H
