#ifndef BASICS_H
#define BASICS_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsError.h>
#include <MDSTk/Math/mdsMatrix.h>
#include <MDSTk/Math/mdsVector.h>
#include <MDSTk/Math/mdsMatrixFunctions.h>

// osg includz
#include <osg/Geode>
#include <osg/Geometry>

namespace conv
{

template < class _From, class _To >
inline _To  convert( const _From & from )
{
    throw mds::base::CError( "invalid conversion" );
    return _To(0);  // we cannot go there
}

template <>
inline mds::math::CDVector  convert( const osg::Vec3 & from )
{
    mds::math::CDVector     result( 3 );
    result.get(0) = from[0];
    result.get(1) = from[1];
    result.get(2) = from[2];
    return result;
}

template <>
inline mds::math::CDVector  convert( const osg::Vec4 & from )
{
    mds::math::CDVector     result( 4 );
    result.get(0) = from[0];
    result.get(1) = from[1];
    result.get(2) = from[2];
    result.get(3) = from[3];
    return result;
}

template <>
inline osg::Vec4            convert( const mds::math::CDVector & from )
{
    osg::Vec4               result;
    result[0] = from.get(0);
    result[1] = from.get(1);
    result[2] = from.get(2);
    result[3] = from.get(3);
    return result;
}

template <>
inline osg::Vec3            convert( const mds::math::CDVector & from )
{
    osg::Vec3               result;
    result[0] = from.get(0);
    result[1] = from.get(1);
    result[2] = from.get(2);
    return result;
}

template <>
inline osg::Matrix          convert( const mds::math::CDMatrix & from )
{
    osg::Matrix             result = osg::Matrix::identity();
    for ( int i = 0; i < 3; i++ )
    {
        for ( int j = 0; j < 3; j++ )
        {
            result( i, j )  =   from.get( i, j );
        }
    }
    return result;
}

template <>
inline mds::math::CDMatrix  convert( const osg::Matrix & from )
{
    mds::math::CDMatrix     result( 4, 4 );

    for ( int i = 0; i < 4; i++ )
    {
        for ( int j = 0; j < 4; j++ )
        {
            result.get( i, j )  =   from( i, j );
        }
    }
    return result;

}

}

#endif // BASICS_H
