#ifndef CCOMMAND_H
#define CCOMMAND_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/base/mdsObject.h>
#include <MDSTk/base/mdsSharedPtr.h>

#include <string>

namespace cmd
{
    class   CCommand : public mds::base::CObject
    {
        public :


                //! Declare smart pointer macro
                MDS_SHAREDPTR( CCommand );

        public :

                //! Default constructor
                CCommand()
                {
                }

                //! Destructor
                virtual ~CCommand()
                {
                }

    };

    class CErrorNotify : public CCommand
    {
        protected :

                std::string sError;

        public :

                CErrorNotify( const std::string & text ) :
                    sError( text )
                {
                }

                virtual ~CErrorNotify()
                {
                }

                std::string get()
                {
                    return sError;
                }
    };

    class CEmptyCommand : public CCommand
    {
        public :

                CEmptyCommand() : CCommand()
                {
                }

                virtual ~CEmptyCommand()
                {
                }
    };
}

#endif // CCOMMAND_H
