#ifndef __SMOOTH_H__
#define __SMOOTH_H__

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Polygonal model smooth module
 */
class CSmooth : public mds::mod::CModule
{
public:
    //! Smart pointer type
    //! - Declares type tSmartPtr
    MDS_SHAREDPTR(CSmooth);

public:
    //! Default constructor
    CSmooth(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CSmooth();

protected:
    //! Virtual method called on startup
    virtual bool startup();

    //! Virtual method called by the processing thread
    virtual bool main();

    //! Called on console shutdown
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:

    //! Number of iterations
    int m_iIterations;

	//! First smoothing parameter
	double	m_dP1;

	//! Second smoothing parameter
	double	m_dP2;

	//! Smoothing method
	std::string	m_sMethod;

	//! Input file name
	std::string	m_sInputFile;

	//! Output file name
	std::string	m_sOutputFile;

};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSmooth::tSmartPtr    CSmoothPtr;


#endif // MDS_SLICEOPTICALFLOW_H