#ifndef CTAUBINSMOOTHER_H
#define CTAUBINSMOOTHER_H

#include <smoothers/CSmoother.h>

//==============================================================================
/**
 *  TaubinSmoother class
 * - implements Taubin smoothing method
 */
class CTaubinSmoother : public CSmoother
{
    protected :

        //! First smoothing parameter 
        double  dFactor1;
			
		//! Second smoothing parameter
		double	dFactor2;

        //! Number of iterations
        int     iIterations;

        //! Number of vertex neighbourhood layers
        int     iLayers;

    public :

        //! Constructor parametrized by smoothing factors and number of iterations
        CTaubinSmoother( double factor1, double factor2, int iterations, int layers = 1 );

        //! Destructor
        virtual ~CTaubinSmoother();

        //! This method smoothes a mesh by Taubin's algorithm
        virtual bool    smooth( CSmoothingMesh * mesh );

        //! This method smoothes one vertex by Taubin's algorithm
        bool            smoothVertex( CSmoothingMesh * mesh,
                                      vctl::MCVertex * actual_vertex,
                                      vctl::MCPoint3D & smoothed_point,
                                      double smooth_factor);

};

#endif // CTAUBINSMOOTHER_H
