#ifndef CHCSMOOTHER_H
#define CHCSMOOTHER_H

#include <smoothers/CSmoother.h>

//==============================================================================
/**
 *  HCSmoother class
 * - implements mesh smoothing by HC algorithm
 */
class CHCSmoother : public CSmoother
{
    protected :

        //! First smoothing parameter
        double  dFactor1;
		
		//! Second smoothing parameter
		double	dFactor2;

        //! Number
        int     iIterations;

        //! Number of vertex neighbourhood layers
        int     iLayers;

    public :

        //! Constructor parametrized by smoothing factors and number of iterations
        CHCSmoother( double factor1, double factor2, int iterations, int layers = 1 );

        //! Destructor
        virtual ~CHCSmoother() {}

        //! This method smoothes a mesh by HC algorithm
        virtual bool    smooth( CSmoothingMesh * mesh );

        //! This method smoothes one vertex by HC algorithm ( phase 1 )
        bool         smoothVertexStep1( vctl::MCVertex * actual_vertex,
                                        vctl::MCPoint3D & smoothed_point,
                                        vctl::MCPoint3D & start_point,
                                        const double & smooth_factor );

        //! This method smoothes one vertex by HC algorithm ( phase 2 )
        bool         smoothVertexStep2( vctl::MCVertex * actual_vertex,
                                        vctl::MCPoint3D & smoothed_point,
                                        vctl::MCPoint3D & start_point,
                                        const double & smooth_factor );
};


#endif // CHCSMOOTHER_H
