#ifndef CBMDSSMOOTHER_H
#define CBMDSSMOOTHER_H

#include <smoothers/CSmoother.h>

//==============================================================================
/**
 *  BMDSSmoother class
 * - implements smoothing by 'bilateral mesh denoising algorithm'
 */
class CBMDSSmoother : public CSmoother
{
    protected :

        //! First smoothing factor 
        double  dFactor1;
		
		//! Second smoothing factor
		double	dFactor2;

        //! Number of iterations
        int     iIterations;

        //! Number of vertex neighbourhood layers
        int     iLayers;

    public :

        //! Constructor parametrized by smoothing factors and number of iterations
        CBMDSSmoother( double factor1, double factor2, int iterations, int layers = 1 );

        //! Desturctor
        virtual ~CBMDSSmoother();

        //! This method smoother a mesh by the BMDS algorithm
        virtual bool    smooth( CSmoothingMesh * mesh );

        //! This method smoothes one vertex by BMDS algorithm
        bool            smoothVertex( CSmoothingMesh * mesh,
                                      vctl::MCVertex * actual_vertex,
                                      vctl::MCPoint3D & smoothed_point );

};

#endif // CBMDSSMOOTHER_H
