#ifndef CVERTEXINFOGENERATOR_H
#define CVERTEXINFOGENERATOR_H

#include <base/CCommand.h>
#include <models/CMesh.h>

//==============================================================================
/**
 * VertexInfoGenerator class
 * - base class for all vertex info(feature) generators
 * - individual generators are responsible for computing vertex features on a mesh
 */
class CVertexInfoGenerator : public cmd::CCommand
{
    public :

			//! Smart pointer declaration
            MDS_SHAREDPTR(CVertexInfoGenerator);

    public :

            //! Constructor
            CVertexInfoGenerator()
            {
            }

            //! Destructor
            virtual ~CVertexInfoGenerator()
            {
            }

            //! Generates all information
            virtual bool generate( CSmoothingMesh * mesh )
            {
                return false;
            };

            //! Initializes instance
            virtual bool init()
            {
                return false;
            };

};

#endif // CVERTEXINFOGENERATOR_H
